'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';
import AnimatedText from '../../../components/AnimatedText';

export default function SafetyResiliencePage() {
  const t = useTranslations('SafetyResiliencePage');
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  return (
    <div className="w-full flex flex-col items-start bg-[#F5F1F0] font-roboto">
      {/* Header */}
      <div className="w-full bg-white">
        <div className="w-full max-w-[1440px] mx-auto">
      {isDesktop ? <Header /> : <MobileHeader />}
        </div>
      </div>
      
      {/* Panorama Section - full width */}
      <section className="flex pb-[60px] flex-col justify-end items-center gap-6 w-full">
        <div 
          className="flex h-[597px] flex-col justify-end items-center gap-6 w-full bg-cover bg-center relative"
          style={{
            backgroundImage: "linear-gradient(180deg, rgba(0, 0, 0, 0.19) 0%, rgba(0, 0, 0, 0.50) 100%), url('/images/safety/91c2644f5a20ff1497b23b5100c47020d9493377.jpg')",
            backgroundColor: 'lightgray'
          }}
        >
          <div className="flex max-w-[1376px] w-full flex-col items-start gap-6 flex-1 mx-auto p-8">
            <div className="flex flex-col items-center gap-3 flex-1 w-full">
              <AnimatedText
                as="h1"
                animation="slideInUp"
                delay={200}
                className="w-full text-white text-center text-[40px] font-light leading-[115%] tracking-[-1.2px] font-roboto"
              >
                {t('title')}
              </AnimatedText>
            </div>
          </div>
        </div>
        
        {/* Description Section */}
        <div className="flex px-8 flex-col justify-end items-center gap-2 w-full">
          <div className="flex w-full max-w-[1376px] mx-auto pl-6 flex-col items-start gap-4 border-l border-[rgba(28,28,28,0.20)]">
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="max-w-[1344px] w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
            >
              {t('desc1')}
              <br /><br />
              {t('desc2')}
            </AnimatedText>
          </div>
        </div>
      </section>

      {/* Footer - full width */}
      <Footer />
    </div>
  );
} 